﻿using System;

namespace SingleAttribute
{
    [Flags]
    public enum ProblemStatus
    {
        Assigned = 0x0001,
        NoProblem = 0x0002,
        Open = 0x0004,
        Resolved = 0x0008
    }


    /// <summary>
    ///     Użycie pojedynczego atrybutu
    /// </summary>
    class SingleAttribute
    {
        static void Main(string[] args)
        {
            ProblemStatus currentStatus =
                 (ProblemStatus.Open | ProblemStatus.Assigned);

            if (((currentStatus & ProblemStatus.NoProblem) != 0) |
                ((currentStatus & ProblemStatus.Resolved) != 0))
            {
                Console.WriteLine("Problem rozwiązany: {0}",
                    currentStatus);
            }
            else
            {
                Console.WriteLine("Problem wciąż aktywny: {0}",
                    currentStatus);
            }

            Console.ReadKey();
        }
    }
}